﻿//////////////////////////////////////////////
// Camera.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkGraphics
{
	class RenderContext ;

	enum class PROJECTION_TYPE ;
	enum class RENDERING_API ;
}

/// Includes ---------------------------------

// nkGraphics
#include "../Dll/DllDefines.h"

#include "../Graph/Node.h"

#include "Frustum.h"

// nkExport
#include <NilkinsExport/Exportable/Exportable.h>

// nkMaths
#include <NilkinsMaths/Algebra/Vector.h>
#include <NilkinsMaths/Algebra/Quaternion.h>
#include <NilkinsMaths/Algebra/Matrix.h>

// nkMemory
#include <NilkinsMemory/Containers/String.h>
#include <NilkinsMemory/Containers/StringView.h>

/// Class ------------------------------------
	
namespace nkGraphics
{
	class DLL_GRAPHICS_EXPORT Camera : public Node
	{		
		public :

			// Getters
			float getNear () const ;
			float getFar () const ;
			const Frustum& getFrustum () ;
			nkMemory::StringView getName () const ;
			float getFov () const ;
			float getOrthographicHeight () const ;
			PROJECTION_TYPE getProjectionType () const ;
			float getAspectRatio () const ;
			bool getAutoUpdateOnContextSwitch () const ;
			bool getHidden () const ;
			const nkMaths::Matrix& getViewMatrix () const ;
			const nkMaths::Matrix& getProjectionMatrix () const ;
			nkMaths::Matrix getViewProjMatrix () const ;

			// Setters
			virtual void setPositionRelative (const nkMaths::Vector& value) override ;
			virtual void setPositionAbsolute (const nkMaths::Vector& value) override ;
			virtual void translateRelative (const nkMaths::Vector& value) override ;
			virtual void translateAbsolute (const nkMaths::Vector& value) override ;
			virtual void setOrientationRelative (const nkMaths::Quaternion& value) override ;
			virtual void setOrientationAbsolute (const nkMaths::Quaternion& value) override ;
			virtual void rotateRelative (const nkMaths::Quaternion& value) override ;
			virtual void rotateAbsolute (const nkMaths::Quaternion& value) override ;
			virtual void setScaleRelative (const nkMaths::Vector& value) override ;
			virtual void setScaleAbsolute (const nkMaths::Vector& value) override ;
			virtual void applyScale (const nkMaths::Vector& value) override ;
			void setNear (float value) ;
			void setFar (float value) ;
			void setName (const nkMemory::StringView& name) ;
			void setFov (float radianValue) ;
			void setOrthographicHeight (float value) ;
			void setProjectionType (PROJECTION_TYPE value) ;
			void setAspectRatio (float widthOnHeight) ;
			void prepareForContext (RenderContext* context) ;
			void setAutoUpdateOnContextSwitch (bool value) ;
			void setHidden (bool value) ;

			// Computing
			void updateViewMatrix () ;
			void updateProjectionMatrix () ;
			void lookAt (const nkMaths::Vector& point, const nkMaths::Vector& enforcedUp = nkMaths::Vector(0, 0, 0, 0)) ;

			// Useful information
			void getNearPlanePoints (nkMaths::Vector& a, nkMaths::Vector& b, nkMaths::Vector& c, nkMaths::Vector& d) ;
			void getFarPlanePoints (nkMaths::Vector& a, nkMaths::Vector& b, nkMaths::Vector& c, nkMaths::Vector& d) ;
			void getFrustumCornersDirectionsWorld (nkMaths::Vector& a, nkMaths::Vector& b, nkMaths::Vector& c, nkMaths::Vector& d) ;
			void getFrustumCornersDirectionsView (nkMaths::Vector& a, nkMaths::Vector& b, nkMaths::Vector& c, nkMaths::Vector& d) ;

			// Raycast
			nkMaths::Vector getDirectionAtPixelWorld (int x, int y, RenderContext* fromContext = nullptr) ;
			nkMaths::Vector getDirectionAtScreenCoordWorld (float x, float y) ;
			nkMaths::Vector getDirectionAtPixelView (int x, int y, RenderContext* fromContext = nullptr) ;
			nkMaths::Vector getDirectionAtScreenCoordView (float x, float y) ;
				
			// Import / export methods
			virtual void exportClassToTree (nkExport::Node* rootNode) override ;
			virtual void importClassFromTree (nkExport::Node* rootNode) override ;

		public :

			// Statics
			static nkMemory::UniquePtr<Camera> create (System* system = nullptr) ;

		private :

			// Functions
			// Constructor
			Camera (System* system) noexcept ;

		private :
		
			// Attributes
			// Name for easy tracking
			nkMemory::String _name ;

			// Rendering info
			nkMaths::Matrix _viewMat ;
			nkMaths::Matrix _projMat ;

			// Clip information
			float _near ;
			float _far ;
			float _aspectRatio ;
			float _fov ;
			float _orthographicHeight ;

			// Current frustum
			Frustum _frustum ;

			// Found renderer for projection
			RENDERING_API _renderer ;

			// Projection requested
			PROJECTION_TYPE _projectionType ;

			// Flags
			bool _dirtyFrustum ;
			bool _autoUpdateOnContextSwitch ;

			// Resource-like
			bool _hidden ;
	} ;
}